/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.git.core.model.ChangedFile;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractStagingHandler
extends AbstractGitHandler {
    AbstractStagingHandler() {
    }

    private ChangedFile getChangedFile(IResource resource) {
        if (!(resource instanceof IFile)) {
            return null;
        }
        GitRepository repo = AbstractStagingHandler.getGitRepositoryManager().getAttached(resource.getProject());
        if (repo == null) {
            return null;
        }
        return this.getChangedFile(repo, resource);
    }

    private ChangedFile getChangedFile(GitRepository repo, IResource resource) {
        return repo.getChangedFileForResource(resource);
    }

    @Override
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        HashMap<GitRepository, ArrayList<ChangedFile>> repoToChangedFiles = new HashMap<GitRepository, ArrayList<ChangedFile>>();
        Collection<IResource> resources = this.getSelectedResources();
        for (IResource iResource : resources) {
            GitRepository repo;
            if (iResource instanceof IContainer) {
                IContainer container = (IContainer)iResource;
                repo = AbstractStagingHandler.getGitRepositoryManager().getAttached(iResource.getProject());
                List files = repo.getChangedFilesForContainer(container);
                for (ChangedFile file : files) {
                    if (!this.changedFileIsValid(file)) continue;
                    ArrayList<ChangedFile> changedFiles = (ArrayList<ChangedFile>)repoToChangedFiles.get(repo);
                    if (changedFiles == null) {
                        changedFiles = new ArrayList<ChangedFile>();
                        repoToChangedFiles.put(repo, changedFiles);
                    }
                    changedFiles.add(file);
                }
                continue;
            }
            ChangedFile correspondingChangedFile = this.getChangedFile(iResource);
            if (!this.changedFileIsValid(correspondingChangedFile)) continue;
            repo = AbstractStagingHandler.getGitRepositoryManager().getAttached(iResource.getProject());
            ArrayList<ChangedFile> changedFiles = (ArrayList<ChangedFile>)repoToChangedFiles.get(repo);
            if (changedFiles == null) {
                changedFiles = new ArrayList<ChangedFile>();
                repoToChangedFiles.put(repo, changedFiles);
            }
            changedFiles.add(correspondingChangedFile);
        }
        for (Map.Entry entry : repoToChangedFiles.entrySet()) {
            this.doOperation((GitRepository)entry.getKey(), (List)entry.getValue());
        }
        return null;
    }

    protected abstract void doOperation(GitRepository var1, List<ChangedFile> var2);

    @Override
    protected boolean calculateEnabled() {
        Collection<IResource> resources = this.getSelectedResources();
        if (resources.isEmpty()) {
            return true;
        }
        for (IResource resource : resources) {
            if (this.isEnabledForResource(resource)) continue;
            return false;
        }
        return true;
    }

    private boolean isEnabledForResource(IResource resource) {
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            GitRepository repo = AbstractStagingHandler.getGitRepositoryManager().getAttached(resource.getProject());
            if (repo != null) {
                List files = repo.getChangedFilesForContainer(container);
                for (ChangedFile file : files) {
                    if (!this.changedFileIsValid(file)) continue;
                    return true;
                }
            }
        }
        return this.changedFileIsValid(this.getChangedFile(resource));
    }

    protected abstract boolean changedFileIsValid(ChangedFile var1);
}

